import java.util.Scanner;

public class Main
{
    public static void main(String[] args) 
    {
        CopiaFile files = new CopiaFile();
        Scanner scanner = new Scanner(System.in);
        String nomeFileIn = "";     //variabile che contiene il nome del file sorgente
        String nomeFileOut = "";    //variabile che contiene il nome del file di destinazione
        
        boolean fileInCorretto = false;
        //ciclo che permette di inserire il nome del file sorgente finchè non è corretto
        do {
            System.out.println(" > Scrivi il nome del file da copiare:");
            nomeFileIn = scanner.next();
            //si controlla che l'utente abbia inserito un nome, e che esista un file con quel nome
            if( nomeFileIn == null || nomeFileIn.equals("") || !files.esisteFile(nomeFileIn))
                System.out.println(" > Devi scrivere il nome di un file esistente:");
            else
                fileInCorretto = true;
        } while(!fileInCorretto);
        
        boolean fileOutCorretto = false;
        //ciclo che permette di inserire il nome del file di destinazione finchè non è corretto
        do {
            System.out.println(" > Scrivi il nome del file di destinazione:");
            nomeFileOut = scanner.next();
            //si controlla che l'utente abbia inserito un nome
            if(nomeFileOut == null || nomeFileOut.equals("")) 
                System.out.println(" > Devi scrivere il nome di un file:");
            else
                fileOutCorretto = true;
        } while(!fileOutCorretto);
        
        //se il file di destinazione esiste, si chiede di sovrascrivere
        boolean esito = false;
        if(files.esisteFile(nomeFileOut))
        {
            System.out.println(" > Il file di destinazione esiste gia', vuoi sovrascriverlo (s/n)?");
            //si legge il comando dell'utente da cui si estrae il primo carattere
            String s = scanner.next();
            char scelta = s.charAt(0);
            //se l'utente ha scritto 's' come primo carattere, si procede alla sovrascrittura eliminando il file
            if(s.charAt(0) == 's') {
                files.rimuoviFile(nomeFileOut);
                esito = files.copiaFile(nomeFileIn, nomeFileOut);
            }
            else {   //l'utente non vuole sovrascrivere il file: si esce
                System.out.println(" > Copia annullata");
                return;
            }
        }
        else    //il file di destinazione non esite: si procede alla copia
            esito = files.copiaFile(nomeFileIn, nomeFileOut);
        //si controlla se la scrittura è stata effettuata
        if(esito == true)
            System.out.println(" > Copia del file eseguita correttamente");
        else
            System.out.println(" > Errore durante la copia del file, l'azione e' stata annullata");
    }
}